Participant <- factor(rep(c(1:8), 6))
Device <- factor(c(rep("Tablet",24), rep("Mobile",24)))
Technique <- factor(rep(c(rep("Gesture",8), rep("Pen",8), 
rep("QWERTY",8)), 2))
Time <- c(1.2,1.4,1.8,2.0,1.1,1.5,1.5,1.7,
+ 2.1,2.5,2.2,2.2,2.9,2.3,2.3,2.6,
+ 3.5,3.4,3.3,3.2,2.9,2.8,3.8,3.4,
+ 2.4,1.8,2.5,2.1,2.2,1.9,1.7,2.3,
+ 2.8,3.1,3.2,4.0,2.9,3.6,3.2,3.7,
+ 4.5,4.8,4.7,4.1,4.1,4.2,4.6,4.9)
data <- data.frame(Device, Technique, Participant, Time)
library(ez)
options(contrasts=c("contr.sum", "contr.poly"))
ezANOVA(data=data, dv=.(Time), wid=.(Participant), within=.(Technique, Device), type=3, detailed=T)
library(MBESS)
ci.R2(F.value=135.8, df.1=2, df.2=14, conf.level=.95, Random.Predictor=T)
ci.R2(F.value=55.1, df.1=2, df.2=14, conf.level=.95, Random.Predictor=T)
ci.R2(F.value=135.8, df.1=2*0.82, df.2=14*0.82, conf.level=.95, Random.Predictor=T)
